#ifndef KMS_UTIL_GENERIC_CONF_PARSER_H
#define KMS_UTIL_GENERIC_CONF_PARSER_H

#include <stdbool.h>
#include <global_types.h>

typedef error_code_t (*line_parser_func_t)(char *line);

typedef struct kml_conf_parser_t
{
	const char *section_name;

	const line_parser_func_t parse_line;

	bool can_defere_parsing;
} kml_conf_parser_t;

void generic_conf_parser_init(const kml_conf_parser_t **parser);

/**
 * call to remove leading and trailing spaces and tabs from the given string.
 *
 * The changes are performed directly on the string, nothing is copied. Leading spaces and tabs are removed by
 * returning a pointer shifted relatively to the given one. Trailing spaces and tabs are replaced by '\0'-
 *
 * \param string the string to trim
 * \param bool is set to true, if after trimming the string is empty
 *
 * \return a string without any leading or trailing spaces or tabs
 */
char *generic_conf_parser_trimline(char *string, bool *is_empty);

error_code_t generic_conf_parser_read_file(const char *conf_file);

bool generic_conf_parser_file_read_in(void);

error_code_t generic_conf_parser_parse(void);

error_code_t generic_conf_parser_parse_early(void);

error_code_t generic_conf_parser_parse_deferred(void);

void generic_conf_parser_deinit(void);

error_code_t generic_conf_parser_add_parameters(char **parameter_list, char *parameters);

#endif
